package de.kaisersite.akwearplayer;

import android.util.Log;
import android.widget.Toast;

import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.WearableListenerService;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;

import de.kaisersite.mylibrary.DownloadJobService;


/*
 *  This is a listener on the  device to get messages via
 *  the datalayer and then pass it to the main activity so it can be
 *  displayed.  the messages should be coming from the wear/watch device.
 */

public class WearReceiveService extends WearableListenerService
{
    private static final String TAG = "WearReceiveService";

    @Override
    public void onMessageReceived(MessageEvent messageEvent)
    {

        if (messageEvent.getPath().equals("/download"))
            {
            Log.d(TAG, "Message path received on phone is: " + messageEvent.getPath());

            try
                {
                String message = new String(messageEvent.getData(),"UTF-8");
                Log.d(TAG, "Message received on phone is: " + message);
                JSONObject json = new JSONObject(message);
                DownloadJobService.startDownload(this, json.getString("title"), json.getString("description"), json.getString("url"),json.getString("description2"),json.getLong("duration"));
                }
            catch (JSONException e)
                {
                e.printStackTrace();
                }
            catch (UnsupportedEncodingException e)
                {
                e.printStackTrace();
                }
            }
        else
            {
            super.onMessageReceived(messageEvent);
            }
    }

}