package de.kaisersite.akwearplayer;

import android.os.Bundle;
import androidx.wear.widget.CircularProgressLayout;
import android.support.wearable.activity.WearableActivity;
import android.view.View;
import android.widget.TextView;

public class Confirmation extends WearableActivity implements CircularProgressLayout.OnTimerFinishedListener, View.OnClickListener
{

    private CircularProgressLayout mCircularProgress;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_confirmation);

        TextView mTextView = (TextView) findViewById(R.id.text);
        mTextView.setText(getIntent().getStringExtra("text"));

        mCircularProgress =
                (CircularProgressLayout) findViewById(R.id.circular_progress);
        mCircularProgress.setOnTimerFinishedListener(this);
        mCircularProgress.setOnClickListener(this);
    }

    @Override
    public void onTimerFinished(CircularProgressLayout layout) {
        // User didn't cancel, perform the action
        setResult(RESULT_OK);
        finish();
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        // Two seconds to cancel the action
        mCircularProgress.setTotalTime(2000);
        // Start the timer
        mCircularProgress.startTimer();
    }

    @Override
    protected void onStop()
    {
        super.onStop();
        mCircularProgress.stopTimer();
        finish();
    }

    @Override
    public void onClick(View view) {
        if (view.equals(mCircularProgress))
            {
            // User canceled, abort the action
            mCircularProgress.stopTimer();
            finish();
            }
    }
}
