package de.kaisersite.mylibrary;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;


import java.util.Set;

public class Tools
{

    public static Intent getMainIntent(Context context)
    {
        Intent notificationIntent = null;
        try
            {
            notificationIntent = new Intent(context,Class.forName("de.kaisersite.akwearplayer.MainActivity"));
            }
        catch (ClassNotFoundException e)
            {
            throw new RuntimeException(e);
            }
        notificationIntent.setAction(Intent.ACTION_MAIN);
        return notificationIntent;
    }

    public static Bitmap getMediaBitmap(String filepath) //filepath is path of music file
    {
        Bitmap image;
        try
            {
            MediaMetadataRetriever mData = new MediaMetadataRetriever();
            mData.setDataSource(filepath);
            byte art[] = mData.getEmbeddedPicture();
            image = BitmapFactory.decodeByteArray(art, 0, art.length);
            }
        catch (Exception e)
            {
            image = null;
            }
        return image;
    }

    public static void debugProcess()
    {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();

        for (Thread thread : threadSet)
            {
            Log.d("threads",thread.getName());
            }
        String ranstr= Long.toString((long)(Math.random()*Math.pow(36,5)),36);
        Log.d("random",ranstr);

    }

    private static int sNumBoundClients = 0;

    public synchronized static void clientConnected() {
        sNumBoundClients++;
    }

    public synchronized static int clientDisconnected() {
        sNumBoundClients--;
        return sNumBoundClients;
    }

}
