/**
 * Copyright (C) 2018 Achim Kaiser
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.kaisersite.mylibrary;

public class PlayListModel extends CustomListItem
{

    public static final int STATE_LOADING = 0;
    public static final int STATE_LOADED = 1;
    public static final int STATE_ERROR = 2;

    private final String url;
    private final String file;
    private final String id;
    private final int state;
    private final long lduration;

    public PlayListModel(int icon, int state, String id, String url, String file, String title, String description, String description2, long duration)
    {
        super(icon, title, description);
        setDescription2(description2);
        lduration=duration;
        this.url = url;
        this.file = file;
        this.id = id;
        this.state = state;
    }

    @Override
    public long getDuration()
    {
        return lduration;
    }

    @Override
    public String getId()
    {
        return id;
    }

    public String getFile()
    {
        return file;
    }

    public String getUrl()
    {
        return url;
    }

    @Override
    public boolean isLoading()
    {
        return state == STATE_LOADING;
    }

    public int getState()
    {
        return state;
    }
}
