/**
 * Copyright (C) 2018 Achim Kaiser
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.kaisersite.mylibrary;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ImageView;

import android.util.Log;
import android.view.View;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class MyUPNPListAdapter extends
       RecyclerView.Adapter<MyUPNPListAdapter.ViewHolder>
{

    private static final String TAG = "MyUPNPListAdapter";
    private List<CustomListItem> mDataSet;
    private final int widthImage;
    private final MyCache<Bitmap> cache;
    private static final int cachesize=30;

    // Custom Controller used to instruct main activity to update {@link Notification} and/or
    // UI for item selected.
    private Controller mController;

    /**
     * Provides reference to the views for each data item. We don't maintain a reference to the
     * {@link ImageView} (representing the icon), because it does not change for each item. We
     * wanted to keep the sample simple, but you could add extra code to customize each icon.
     */
    public static class ViewHolder extends RecyclerView.ViewHolder
    {
        public TextView titleView;
        public TextView descriptionView;
        public TextView description2View;
        public ImageView imageView;
        public ProgressBar progressView;
        public TextView timeView;
        public String iconurl;

        public ViewHolder(View view)
        {
            super(view);
            imageView = (ImageView) view.findViewById(R.id.icon);
            titleView = (TextView) view.findViewById(R.id.title);
            descriptionView = (TextView) view.findViewById(R.id.description);
            description2View = (TextView) view.findViewById(R.id.description2);
            progressView = (ProgressBar) view.findViewById(R.id.progress);
            timeView =  view.findViewById(R.id.time);
            iconurl = null;
        }

        @Override
        public String toString()
        {
            return (String) titleView.getText();
        }
    }

    public MyUPNPListAdapter(Context context, Controller controller, List<CustomListItem> dataSet)
    {
        mDataSet = dataSet;
        mController = controller;
        widthImage = (int)context.getResources().getDimension(R.dimen.albumimagewidth);
        cache=new MyCache<>(cachesize);
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType)
    {
        Log.d(TAG, "Element created.");
        View view = LayoutInflater.from(viewGroup.getContext())
                .inflate(R.layout.list, viewGroup, false);

        final ViewHolder viewHolder = new ViewHolder(view);
        viewHolder.itemView.setOnClickListener(new View.OnClickListener()
        {

            @Override
            public void onClick(View view)
            {
                try
                    {
                    mController.itemSelected(mDataSet.get(viewHolder.getAdapterPosition()));
                    }
                catch (ArrayIndexOutOfBoundsException e)
                    {}

            }
        });
        Log.d(TAG, "Ecache size"+cachesize);
        return viewHolder;

    }

    @Override
    public void onBindViewHolder(@NonNull final ViewHolder viewHolder, final int position)
    {
        Log.d(TAG, "Element " + position + " set.");


        CustomListItem entry = mDataSet.get(position);
        viewHolder.iconurl = entry.getIconUrl();
        if (viewHolder.iconurl != null)
            {
            if (cache.containsKey(viewHolder.iconurl))
                {
                viewHolder.imageView.setImageBitmap(cache.get(viewHolder.iconurl));
                }
            else
                {
                viewHolder.imageView.setImageResource(entry.getIcon());
                RemoteImage a = new RemoteImage();
                a.iconurl = viewHolder.iconurl;
                a.viewHolder=viewHolder;
                a.myUPNPListAdapter=this;
                new PicLoad2().execute(a);
                }
            }
        else
            {
            viewHolder.imageView.setImageResource(entry.getIcon());
            }

        viewHolder.titleView.setText(entry.getTitle());

        String description = entry.getDescription();
        if (description == null)
            viewHolder.description2View.setVisibility(View.GONE);
        else
            {
            viewHolder.description2View.setVisibility(View.VISIBLE);
            viewHolder.descriptionView.setText(description);
            }

        String description2 = entry.getDescription2();
        if (entry.getDuration()>=0)
            {
            viewHolder.timeView.setVisibility(View.VISIBLE);
            viewHolder.timeView.setText(viewHolder.timeView.getContext().getString(R.string.timeHHMM,entry.getDuration()/60000,entry.getDuration()%60000/1000));
            }
        else
            {
            viewHolder.timeView.setVisibility(View.GONE);
            }
        if (description2 == null)
            viewHolder.description2View.setVisibility(View.GONE);
        else
            {
            viewHolder.description2View.setVisibility(View.VISIBLE);
            viewHolder.description2View.setText(description2);
            }
        if (entry.isLoading())
            {
            viewHolder.imageView.setVisibility(View.INVISIBLE);
            viewHolder.progressView.setVisibility(View.VISIBLE);
            }
        else
            {
            viewHolder.imageView.setVisibility(View.VISIBLE);
            viewHolder.progressView.setVisibility(View.INVISIBLE);
            }
     }

    public static class PicLoad2 extends AsyncTask<RemoteImage,Void,RemoteImage>
    {
        @Override
        protected RemoteImage doInBackground(RemoteImage... albumImages)
        {
            RemoteImage albumImage=albumImages[0];
            HttpURLConnection c = null;
            InputStream in = null;
            try {
                URL u = new URL(albumImage.iconurl);
                c = (HttpURLConnection) u.openConnection();
                c.setRequestMethod("GET");
                //c.setDoOutput(true);
                c.connect();
                in = c.getInputStream();
                albumImage.bitmap = BitmapFactory.decodeStream(in);

                }
            catch (Exception e)
                {
                }
            try
                {
                if (in != null)
                    in.close();
                if (c != null)
                    c.disconnect();
                }
            catch (IOException e)
                {
                e.printStackTrace();
                }
            if (albumImage.bitmap!=null)
                albumImage.bitmap=Bitmap.createScaledBitmap(albumImage.bitmap,albumImage.myUPNPListAdapter.widthImage,albumImage.bitmap.getHeight()*albumImage.myUPNPListAdapter.widthImage/albumImage.bitmap.getWidth(),true);

            return albumImage;
        }

        @Override
        protected void onPostExecute(RemoteImage result) {
            if (result.bitmap!=null && result.iconurl.equals(result.viewHolder.iconurl))
                {
                result.myUPNPListAdapter.cache.put(result.iconurl,result.bitmap);
                result.viewHolder.imageView.setImageBitmap(result.bitmap);
                }
        }

    }

    public class RemoteImage
    {
        Bitmap bitmap=null;
        String iconurl;
        MyUPNPListAdapter myUPNPListAdapter;
        ViewHolder viewHolder;
    }

    @Override
    public long getItemId(int position)
    {
        return position;
    }

    @Override
    public int getItemCount()
    {
        return mDataSet.size();
    }


    public static interface Controller
    {
        public void itemSelected(CustomListItem notificationStyleSelected);
    }
}
