package de.kaisersite.mylibrary;

import android.media.MediaPlayer;
import android.util.Log;

import java.io.File;
import java.io.IOException;

public class MyMediaPlayerDual implements IPlayer
{
    private static final String TAG = "MyMediaPlayerDual";
    private MediaPlayer mMediaPlayer;
    private MediaPlayer mMediaPlayerNext;
    private OnPlayInfoListener onPlayInfoListener;
    private PlayListModel mPlm;
    private PlayListModel mPlmNext;

    public MyMediaPlayerDual()
    {
        mMediaPlayer=new MediaPlayer();
        mMediaPlayerNext=new MediaPlayer();
        mMediaPlayer.setOnCompletionListener(mCompletionListener);
        mMediaPlayer.setOnPreparedListener(mPreparedListener);
        mMediaPlayerNext.setOnCompletionListener(mCompletionListener);
        mMediaPlayerNext.setOnPreparedListener(mPreparedListener);
    }

    @Override
    public boolean start(PlayListModel plm)
    {
        if (mPlm!=null && plm.getFile().equals(mPlm.getFile()))
            {
            mMediaPlayer.start();
            sendPlayinfo();
            return true;
            }
        mPlmNext=null;
        mMediaPlayer.reset();
        mMediaPlayerNext.reset();
        if (!new File(plm.getFile()).exists())
            return false;
        try
            {
            mMediaPlayer.setDataSource(plm.getFile());
            }
        catch (IOException e)
            {
            return false;
            }
        mPlm=plm;
        mMediaPlayer.prepareAsync();
        return true;
    }

    @Override
    public void pause()
    {
        mMediaPlayer.pause();
        sendPlayinfo();
    }

    @Override
    public void stop()
    {
        mMediaPlayer.stop();
    }


    @Override
    public boolean setNext(PlayListModel plm)
    {
        if (plm==null)
            {
            mPlmNext=null;
            mMediaPlayerNext.reset();
            mMediaPlayer.setNextMediaPlayer(null);
            return true;
            }
        if (mPlmNext!=null && plm.getFile().equals(mPlmNext.getFile()))
            {
            return true;
            }
        mPlmNext=null;
        mMediaPlayerNext.reset();
        mMediaPlayer.setNextMediaPlayer(null);
        if (!new File(plm.getFile()).exists())
            {
            return false;
            }
        try
            {
            mMediaPlayerNext.setDataSource(plm.getFile());
            }
        catch (IOException e)
            {
            return false;
            }
        Log.d(TAG,"nextid:"+plm.getId());
        mPlmNext=plm;
        mMediaPlayerNext.prepareAsync();
        return true;
    }

    @Override
    public int getDuration()
    {
        return mMediaPlayer.getDuration();
    }

    @Override
    public void seekTo(int seekto)
    {
        mMediaPlayer.seekTo(seekto);
    }


    @Override
    public int getCurrentPosition()
    {
        return mMediaPlayer.getCurrentPosition();
    }

    @Override
    public void setOnPlayInfoListener(OnPlayInfoListener listener)
    {
        onPlayInfoListener=listener;
    }

    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener()
    {
        @Override
        public void onCompletion(MediaPlayer mp)
        {
            mPlm=mPlmNext;
            mPlmNext=null;
            MediaPlayer zwischen=mMediaPlayer;
            mMediaPlayer=mMediaPlayerNext;
            mMediaPlayerNext=zwischen;
            sendPlayinfo();
        }
    };

    private MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener()
    {
        @Override
        public void onPrepared(MediaPlayer mp)
        {
            if (mp==mMediaPlayerNext)
                {
                mMediaPlayer.setNextMediaPlayer(mMediaPlayerNext);
                Log.d(TAG,"finishpreparenext");
                }
            else
                {
                mMediaPlayer.start();
                mMediaPlayer.setNextMediaPlayer(null);
                sendPlayinfo();
                }
        }
    };

    private void sendPlayinfo()
    {
        onPlayInfoListener.onPlayInfo(mPlm);
    }

    @Override
    public void release()
    {
        mMediaPlayer.release();
        mMediaPlayerNext.release();
    }


    @Override
    public boolean isPlaying()
    {
        return mMediaPlayer.isPlaying();
    }

}
