/**
 * Copyright (C) 2014 Casper Jørgensen
 * Modifications copyright (C) 2018 Achim Kaiser
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.kaisersite.mylibrary;

public class CustomListItem
{

    private int icon;
    private String title;
    private String description;
    private String description2;
    private String iconUrl;
    private Boolean loading = false;

    protected CustomListItem(int icon)
    {
        this(icon, null, null, null, null);
    }

    public CustomListItem(int icon, String title, String description)
    {
        this(icon, null, title, description, null);
    }

    public CustomListItem(int icon, String iconUrl, String title,
                          String description, String description2)
    {
        this.icon = icon;
        this.iconUrl = iconUrl;
        this.title = title;
        this.description = description;
        this.description2 = description2;
    }

    public String getId()
    {
        return "";
    }

    public int getIcon()
    {
        return this.icon;
    }

    public void setIcon(int icon)
    {
        this.icon = icon;
    }

    public String getIconUrl()
    {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl)
    {
        this.iconUrl = iconUrl;
    }

    public String getTitle()
    {
        return this.title;
    }

    public String getDescription()
    {
        return this.description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public String getDescription2()
    {
        return this.description2;
    }

    public void setDescription2(String description)
    {
        this.description2 = description;
    }

    public boolean isLoading()
    {
        return loading;
    }

    public void setLoading(boolean loading)
    {
        this.loading = loading;
    }

    public long getDuration()
    {
        return -1;
    }
}
