/**
 * Copyright (C) 2018 Achim Kaiser
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.kaisersite.akwearplayer;

import androidx.recyclerview.widget.RecyclerView;
import androidx.wear.widget.WearableLinearLayoutManager;
import android.view.View;

public class MyScrollingLayoutCallback extends WearableLinearLayoutManager.LayoutCallback {
    private static final float FACTOR = 0.65f;

    private float mProgressToCenter;

    @Override
    public void onLayoutFinished(View child, RecyclerView parent) {

        if (!child.getContext().getResources().getConfiguration().isScreenRound())
            return;

        float yRelativeToCenterOffset = ((child.getY()+child.getHeight() / 2.0f) / parent.getHeight());
        mProgressToCenter = Math.abs(0.5f - yRelativeToCenterOffset);
        mProgressToCenter = (float)Math.cos(mProgressToCenter*Math.PI* FACTOR);

        child.setScaleX(mProgressToCenter);
        child.setScaleY(mProgressToCenter);
    }
}
