package de.kaisersite.mylibrary;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.util.Log;
import android.widget.Toast;

import org.fourthline.cling.android.AndroidUpnpService;
import org.fourthline.cling.android.AndroidUpnpServiceImpl;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.registry.DefaultRegistryListener;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.support.avtransport.callback.GetMediaInfo;
import org.fourthline.cling.support.avtransport.callback.GetPositionInfo;
import org.fourthline.cling.support.avtransport.callback.GetTransportInfo;
import org.fourthline.cling.support.avtransport.callback.Pause;
import org.fourthline.cling.support.avtransport.callback.Play;
import org.fourthline.cling.support.avtransport.callback.SetAVTransportURI;
import org.fourthline.cling.support.avtransport.callback.SetNextAVTransportURI;
import org.fourthline.cling.support.avtransport.callback.Stop;
import org.fourthline.cling.support.model.MediaInfo;
import org.fourthline.cling.support.model.PositionInfo;
import org.fourthline.cling.support.model.TransportInfo;
import org.fourthline.cling.support.model.TransportState;

import java.util.Set;

import static android.content.Context.POWER_SERVICE;

public class MyMediaPlayerUPNP implements IPlayer
{
    private static final String TAG = "MyMediaPlayerUPNP";
    public static final String UPNP_INFO = "UPNP_INFO";
    private Context mContext;
    private OnPlayInfoListener onPlayInfoListener;
    private PlayListModel mPlm;
    private PlayListModel mPlmNext;
    private AndroidUpnpService mService;
    private org.fourthline.cling.model.meta.Service avTrans;
    private long starttime =0;
    private boolean bPaused=false;
    private PlayListModel mPlmServiceWait=null;
    private Handler handler;
    private WaitForNextTask taskWaitForNext;
    private WaitForCloseTask taskWaitForClose;
    private GetTimeTask taskGetTime;
    private GetTransportTask taskWaitForStopPlaying;
    private PowerManager.WakeLock wakeLock;
    private boolean startupnp=true;
    private boolean bLastIsError;
    private boolean bLastIsError2;

    public MyMediaPlayerUPNP(Context context)
    {
        mContext=context;
        LocalBroadcastManager.getInstance(mContext).registerReceiver(mMessageReceiver, new IntentFilter("wlan_status"));

        PowerManager powerManager = (PowerManager) mContext.getSystemService(POWER_SERVICE);
        wakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,"AKWearPlayer::UPNPPlayTag");
        wakeLock.acquire();
        NetworkManaging.getInstance(mContext).addRegistration();
        Toast.makeText(context,context.getString(R.string.castto,CurrentDevice.getName(context)),Toast.LENGTH_LONG).show();
        sendPlayerStatus(mContext.getString(R.string.upnp_devices_wait_for_wifi),true);
        handler=new Handler(Looper.getMainLooper());
        taskWaitForNext =new WaitForNextTask();
        taskGetTime =new GetTimeTask();
        taskWaitForStopPlaying =new GetTransportTask();
        taskWaitForClose =new WaitForCloseTask();
    }

    private Boolean bindServiceConnection()
    {
        Context context = mContext.getApplicationContext();
        if (context == null)
            return false;

        context.bindService(
                new Intent(mContext, AndroidUpnpServiceImpl.class),
                serviceConnection, Context.BIND_AUTO_CREATE
        );

        Tools.clientConnected();

        return true;
    }

    private Boolean unbindServiceConnection()
    {
        if (mService != null)
            mService.getRegistry().removeListener(mListener);

        final Context context = mContext.getApplicationContext();
        if (context == null)
            return false;

        if (Tools.clientDisconnected()>0)
            return true;
        new Thread()
        {
            public void run()
            {
                mService = null;
                Log.d(TAG,"UPNP Service stop");

                Set<Thread> threadSet = Thread.getAllStackTraces().keySet();

                for (Thread thread : threadSet)
                    {
                    if (thread.getName().startsWith("cling"))
                        {
                        thread.interrupt();
                        }
                    }

                try
                    {
                    context.unbindService(serviceConnection);
                    }
                catch (IllegalArgumentException ignore)
                    {
                    } // Already unbound
            }
        }.start();

        return true;
    }

    private ServiceConnection serviceConnection = new ServiceConnection()
    {
        public void onServiceConnected(ComponentName className, IBinder service)
        {
            mService = (AndroidUpnpService) service;
            mService.getRegistry().addListener(mListener);

            for (Device device : mService.getRegistry().getDevices())
                deviceAdded(device);

            mService.getControlPoint().search();
        }

        public void onServiceDisconnected(ComponentName className)
        {
            mService = null;
        }
    };

    private DefaultRegistryListener mListener= new DefaultRegistryListener()
    {
        @Override
        public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device)
        {
            MyMediaPlayerUPNP.this.deviceAdded(device);
        }

        @Override
        public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex)
        {
            MyMediaPlayerUPNP.this.deviceRemoved(device);
        }

        @Override
        public void remoteDeviceAdded(Registry registry, RemoteDevice device)
        {
            MyMediaPlayerUPNP.this.deviceAdded(device);
        }

        @Override
        public void remoteDeviceRemoved(Registry registry, RemoteDevice device)
        {
            MyMediaPlayerUPNP.this.deviceRemoved(device);
        }

        @Override
        public void localDeviceAdded(Registry registry, LocalDevice device)
        {
            MyMediaPlayerUPNP.this.deviceAdded(device);
        }

        @Override
        public void localDeviceRemoved(Registry registry, LocalDevice device)
        {
            MyMediaPlayerUPNP.this.deviceRemoved(device);
        }

  };
    public void deviceAdded(Device device)
    {
        if (device.isFullyHydrated() &&
                CurrentDevice.getId(mContext).equals(device.getIdentity().getUdn().getIdentifierString()))
            {
            handler.removeCallbacks(taskWaitForClose);
            DeviceModel deviceModel = new DeviceModel(R.drawable.ic_device, device);
            avTrans=deviceModel.getAVTransport();
            start(mPlmServiceWait);
            }
    }

    public void deviceRemoved(Device device)
    {
        if (CurrentDevice.getId(mContext).equals(device.getIdentity().getUdn().getIdentifierString()))
            {
            sendPlayerStatus(mContext.getString(R.string.device_removed_from_UPNPStack),false);
            avTrans=null;
            handler.postDelayed(taskWaitForClose, 5*60*1000); // 5 Minutes to wait for devices
            sendPlayerStatus(mContext.getString(R.string.upnp_devices_waiting_for_devices),true);

            mService.getRegistry().removeAllRemoteDevices();

            for (Device device2 : mService.getRegistry().getDevices())
                deviceAdded(device2);

            mService.getControlPoint().search();
            }
    }


    // Receive Network Status
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            if ("available".equals(intent.getStringExtra("status")))
                {
                if (startupnp)
                    {
                    startupnp=false;
                    handler.postDelayed(taskWaitForClose, 10000); // 10 seconds to wait for devices
                    sendPlayerStatus(mContext.getString(R.string.upnp_devices_waiting_for_devices),true);
                    bindServiceConnection();
                    }
                else if (!bPaused)
                    {
                    Log.d(TAG,"resume");
                    sendPlayerStatus(mContext.getString(R.string.network_resumed),false);
                    handler.postDelayed(taskWaitForNext, 2000); // 2 sec to make sure wlan is available
                    }
                }
            else if ("lost".equals(intent.getStringExtra("status")))
                {
                handler.removeCallbacks(taskWaitForStopPlaying);
                handler.removeCallbacks(taskGetTime);
                handler.removeCallbacks(taskWaitForNext);
                handler.removeCallbacks(taskWaitForClose);
                sendPlayerStatus(mContext.getString(R.string.upnp_devices_wait_for_wifi),true);
                }
            else if ("timeout_lost".equals(intent.getStringExtra("status")))
                {
                sendPlayerStatus(mContext.getString(R.string.wlan_connection_error),false);
                handler.postDelayed(taskWaitForClose,5*60*1000);
                }
            else if ("timeout".equals(intent.getStringExtra("status")))
                {
                CurrentDevice.setDevice(mContext,null,null);
                sendPlayerStatus("", false);
                Intent intent2 = new Intent(MyMediaService.CLOSE_PLAYER);
                mContext.sendBroadcast(intent2);
                }
        }
    };

    @Override
    public boolean start(final PlayListModel plm)
    {
        if (mService == null || avTrans==null)
            {
            mPlmServiceWait = plm;
            return true;
            }
        if (bPaused && mPlm != null && plm.getFile().equals(mPlm.getFile()))
            {
            play();
            return true;
            }
        sequenceStopSetAndPlay1(plm);
        return true;
    }

    private void sequenceStopSetAndPlay1(final PlayListModel plm)
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        Log.d(TAG,"sequenceStopSetAndPlay1");
        mService.getControlPoint().execute(new Stop(avTrans){

            @Override
            public void success(ActionInvocation invocation) {
                bPaused=false;
                starttime =System.currentTimeMillis();
                Log.d(TAG,"Stop Execution successful");
                sequenceStopSetAndPlay2(plm);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"Stop Execution failed");
                sequenceStopSetAndPlay2(plm);
            }
        });

    }

    private void sequenceStopSetAndPlay2(final PlayListModel plm)
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        sendPlayerStatus(mContext.getString(R.string.prepare_item),true);
        Log.d(TAG,"sequenceStopSetAndPlay2 "+plm.getUrl());
        mService.getControlPoint().execute(new SetAVTransportURI(avTrans, plm.getUrl(), null)
                {
                    @Override
                    public void success(ActionInvocation invocation) {
                        Log.d(TAG,"SetAVTransportURI Execution successful");
                        mPlm=plm;
                        play();
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
                    {
                        Log.d(TAG,"SetAVTransportURI Execution failed");
                        sendPlayerStatus(defaultMsg,false);
                        Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                        mContext.sendBroadcast(intent);
                    }
                });
    }

    private void play()
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        sendPlayerStatus(mContext.getString(R.string.play_item),true);
        Log.d(TAG,"Play");
        mService.getControlPoint().execute(new Play(avTrans){

            @Override
            public void success(ActionInvocation invocation) {
                bPaused=false;
                starttime =System.currentTimeMillis();
                handler.postDelayed(taskGetTime, 1000);
                Log.d(TAG,"Play Execution successful");
                handler.postDelayed(taskWaitForNext, 1000);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"Play Execution failed");
                sendPlayerStatus(defaultMsg,false);
                Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                mContext.sendBroadcast(intent);
            }
        });

    }

    public class WaitForNextTask implements Runnable
    {
        @Override
        public void run() {
            handler.removeCallbacks(this);
            waitForNext();
        }
    }

    public class WaitForCloseTask implements Runnable
    {
        @Override
        public void run() {
            handler.removeCallbacks(this);
            stopAndClose();
        }
    }

    public class GetTimeTask implements Runnable
    {
        @Override
        public void run() {
            handler.removeCallbacks(this);
            getTime();
        }
    }

    public class GetTransportTask implements Runnable
    {
        @Override
        public void run() {
            handler.removeCallbacks(this);
            getWaitForStopPlaying();
        }
    }

    private void waitForNext()
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        if (bPaused)
            return;
        sendPlayerStatus(mContext.getString(R.string.wait_for_next),true);
        Log.d(TAG,"MediaInfo");
        mService.getControlPoint().execute(new GetMediaInfo(avTrans){

            @Override
            public void received(ActionInvocation invocation, MediaInfo mediaInfo)
            {
                bLastIsError=false;
                Log.d(TAG,"MediaInfo Execution successful "+mediaInfo.getCurrentURI());
                Log.d(TAG,"MediaInfo Execution successful "+mediaInfo.getNextURI());
                if (mediaInfo.getCurrentURI().equals(mPlm.getUrl()))
                    {
                    if (mediaInfo.getNextURI()==null || !mediaInfo.getNextURI().equals(mPlmNext.getUrl()))
                        {
                        onPlayInfoListener.onPlayInfo(mPlm);
                        }
                    else if (mediaInfo.getNextURI().equals(mPlmNext.getUrl()))
                        {
                        sendPlayerStatus(mContext.getString(R.string.wait_for_next),false);
                        handler.postDelayed(taskWaitForNext, Math.max(1000,mPlm.getDuration()-System.currentTimeMillis()+starttime));
                        }
                    }
                else
                    {
                    if (mediaInfo.getCurrentURI().equals(mPlmNext.getUrl()))
                        {
                        starttime =System.currentTimeMillis();
                        handler.postDelayed(taskGetTime, 1000);
                        mPlm = mPlmNext;
                        mPlmNext = null;
                        onPlayInfoListener.onPlayInfo(mPlm);
                        }
                    else
                        {
                        sendPlayerStatus(mContext.getString(R.string.other_control_detected),false);
                        Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                        mContext.sendBroadcast(intent);
                        }
                    }
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"getinfo Execution failed");
                sendPlayerStatus(defaultMsg,false);
                if (bLastIsError)
                    {
                    Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                    mContext.sendBroadcast(intent);
                    }
                else
                    {
                    bLastIsError=true;
                    handler.postDelayed(taskWaitForNext, 10000);
                    }
            }
        });
    }

    private void getTime()
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        Log.d(TAG,"GetPositionInfo");
        mService.getControlPoint().execute(new GetPositionInfo(avTrans){

            @Override
            public void received(ActionInvocation invocation, PositionInfo positionInfo)
            {
                bLastIsError2=false;
                Log.d(TAG,"GetPositionInfo Execution successful "+positionInfo.getTrackURI());
                Log.d(TAG,"GetPositionInfo Execution successful "+positionInfo.getTrackElapsedSeconds());
                if (positionInfo.getTrackURI().equals(mPlm.getUrl()))
                    {
                    starttime = System.currentTimeMillis() - positionInfo.getTrackElapsedSeconds() * 1000;
                    if (positionInfo.getTrackElapsedSeconds() == 0)
                        {
                        handler.postDelayed(taskGetTime, 1000);
                        return;
                        }
                    onPlayInfoListener.onPlayInfo(mPlm);
                    }
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"GetPositionInfo Execution failed");
                sendPlayerStatus(defaultMsg,false);
                if (bLastIsError2)
                    {
                    Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                    mContext.sendBroadcast(intent);
                    }
                else
                    {
                    bLastIsError2=true;
                    handler.postDelayed(taskGetTime, 10000);
                    }
            }
        });

    }

    private void getWaitForStopPlaying()
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        sendPlayerStatus(mContext.getString(R.string.wait_for_finish_playing),true);
        Log.d(TAG,"GetTransportInfo");
        mService.getControlPoint().execute(new GetTransportInfo(avTrans){

            @Override
            public void received(ActionInvocation invocation, TransportInfo transportInfo)
            {
                Log.d(TAG,"GetTransportInfo Execution successful "+transportInfo.getCurrentTransportState());
                if (transportInfo.getCurrentTransportState()==TransportState.STOPPED)
                    stopAndClose();
                else
                    {
                    sendPlayerStatus(mContext.getString(R.string.wait_for_finish_playing),false);
                    handler.postDelayed(taskWaitForStopPlaying, Math.max(1000,mPlm.getDuration()-System.currentTimeMillis()+starttime));
                    }
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"GetTransportInfo Execution failed");
                sendPlayerStatus(defaultMsg,false);
                Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                mContext.sendBroadcast(intent);
            }
        });

    }

    @Override
    public void pause()
    {
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        sendPlayerStatus(mContext.getString(R.string.send_pause),true);
        Log.d(TAG,"Pause");
        mService.getControlPoint().execute(new Pause(avTrans){

            @Override
            public void success(ActionInvocation invocation) {
                bPaused=true;
                Log.d(TAG,"Pause Execution successful");
                sendPlayerStatus(mContext.getString(R.string.playing_paused),false);
                onPlayInfoListener.onPlayInfo(mPlm);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"Pause Execution failed");
                sendPlayerStatus(defaultMsg,false);
                stopAndClose();
            }
        });

    }

    @Override
    public void stop()
    {
        stopAndClose();
    }


    @Override
    public boolean setNext(final PlayListModel plm)
    {
        handler.removeCallbacks(taskWaitForStopPlaying);
        if (plm==null && mPlmNext==null)
            {
            sendPlayerStatus(mContext.getString(R.string.wait_for_finish_playing),false);
            handler.postDelayed(taskWaitForStopPlaying, Math.max(1000,mPlm.getDuration()-System.currentTimeMillis()+starttime));
            return true;
            }
        if (plm!=null && mPlmNext!=null && plm.getFile().equals(mPlmNext.getFile()))
            {
            return true;
            }
        if (avTrans==null)
            {
            sendPlayerStatus(mContext.getString(R.string.device_not_found),false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return false;
            }
        Log.d(TAG,"SetNextAVTransportURI "+(plm!=null?plm.getUrl():"null"));
        mService.getControlPoint().execute(new SetNextAVTransportURI(avTrans, plm!=null?plm.getUrl():null, null)
        {
            @Override
            public void success(ActionInvocation invocation) {
                Log.d(TAG,"SetNextAVTransportURI Execution successful");
                mPlmNext=plm;
                handler.postDelayed(taskWaitForNext, 1000);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG," SetNextAVTransportURI Execution failed");
                sendPlayerStatus(mContext.getString(R.string.wait_for_finish_playing),false);
                handler.postDelayed(taskWaitForStopPlaying, Math.max(1000,mPlm.getDuration()-System.currentTimeMillis()+starttime));
            }
        });
        return true;
    }

    private void stopAndClose()
    {
        handler.removeCallbacks(taskWaitForStopPlaying);
        handler.removeCallbacks(taskGetTime);
        handler.removeCallbacks(taskWaitForNext);
        handler.removeCallbacks(taskWaitForClose);
        if (avTrans==null)
            {
            CurrentDevice.setDevice(mContext,null,null);
            sendPlayerStatus("",false);
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            mContext.sendBroadcast(intent);
            return;
            }
        sendPlayerStatus(mContext.getString(R.string.send_stop),true);
        Log.d(TAG,"Stop");
        mService.getControlPoint().execute(new Stop(avTrans){

            @Override
            public void success(ActionInvocation invocation) {
                Log.d(TAG,"Stop Execution successful");
                sendPlayerStatus(mContext.getString(R.string.playing_stopped),false);
                Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                mContext.sendBroadcast(intent);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg)
            {
                Log.d(TAG,"Stop Execution failed");
                sendPlayerStatus(mContext.getString(R.string.playing_stopped),false);
                Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
                mContext.sendBroadcast(intent);
            }
        });

    }

    @Override
    public int getDuration()
    {
        return mPlm==null?0:(int)mPlm.getDuration();
    }

    @Override
    public void seekTo(int seekto)
    {


    }

    private void sendPlayerStatus(String text, boolean progress)
    {
        Intent bcintent = new Intent(UPNP_INFO);
        bcintent.putExtra("statustext", text);
        bcintent.putExtra("progress", progress);
        LocalBroadcastManager.getInstance(mContext).sendBroadcast(bcintent);

    }

    @Override
    public int getCurrentPosition()
    {
        return (int)(System.currentTimeMillis()- starttime);
    }

    @Override
    public void setOnPlayInfoListener(OnPlayInfoListener listener)
    {
        onPlayInfoListener=listener;
    }


    @Override
    public void release()
    {
        Toast.makeText(mContext,R.string.closed,Toast.LENGTH_LONG).show();
        handler.removeCallbacks(taskWaitForNext);
        handler.removeCallbacks(taskGetTime);
        handler.removeCallbacks(taskWaitForStopPlaying);
        handler.removeCallbacks(taskWaitForClose);
        unbindServiceConnection();
        LocalBroadcastManager.getInstance(mContext).unregisterReceiver(mMessageReceiver);
        NetworkManaging.getInstance(mContext).removeRegistration();
        wakeLock.release();
    }


    @Override
    public boolean isPlaying()
    {
        return mPlm!=null && !bPaused;
    }

}
