package de.kaisersite.mylibrary;

import android.media.MediaPlayer;

import java.io.File;
import java.io.IOException;

public class MyMediaPlayer implements IPlayer
{
    private final MediaPlayer mMediaPlayer;
    private OnPlayInfoListener onPlayInfoListener;
    private PlayListModel mPlm;

    public MyMediaPlayer()
    {
        mMediaPlayer=new MediaPlayer();
        mMediaPlayer.setOnCompletionListener(mCompletionListener);
        mMediaPlayer.setOnPreparedListener(mPreparedListener);
    }

    @Override
    public boolean start(PlayListModel plm)
    {
        if (mPlm!=null && plm.getFile().equals(mPlm.getFile()))
            {
            mMediaPlayer.start();
            sendPlayinfo();
            return true;
            }
        if (!new File(plm.getFile()).exists())
            return false;
        mMediaPlayer.reset();
        try
            {
            mMediaPlayer.setDataSource(plm.getFile());
            }
        catch (IOException e)
            {
            return false;
            }
        mPlm=plm;
        mMediaPlayer.prepareAsync();
        return true;
    }

    @Override
    public void pause()
    {
        mMediaPlayer.pause();
        sendPlayinfo();
    }

    @Override
    public void stop()
    {
        mMediaPlayer.stop();
    }


    @Override
    public boolean setNext(PlayListModel plm)
    {
        return true;
    }

    @Override
    public int getDuration()
    {
        return mMediaPlayer.getDuration();
    }

    @Override
    public void seekTo(int seekto)
    {
        mMediaPlayer.seekTo(seekto);
    }

    @Override
    public int getCurrentPosition()
    {
        return mMediaPlayer.getCurrentPosition();
    }

    @Override
    public void setOnPlayInfoListener(OnPlayInfoListener listener)
    {
        onPlayInfoListener=listener;
    }

    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener()
    {
        @Override
        public void onCompletion(MediaPlayer mp)
        {
            mPlm=null;
            sendPlayinfo();
        }
    };

    private MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener()
    {
        @Override
        public void onPrepared(MediaPlayer mp)
        {
            mMediaPlayer.start();
            sendPlayinfo();
        }
    };

    private void sendPlayinfo()
    {
        onPlayInfoListener.onPlayInfo(mPlm);
    }

    @Override
    public void release()
    {
        mMediaPlayer.release();
    }


    @Override
    public boolean isPlaying()
    {
        return mMediaPlayer.isPlaying();
    }

}
