package de.kaisersite.mylibrary;

import android.util.Log;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MyCache<T>
{
    private int cachesize;
    InternalCache<String, T> list;


    private class InternalCache<K, V> extends LinkedHashMap<K, V>
    {
        public InternalCache()
        {
            super((int)(cachesize/0.75)+1,0.75f,true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest)
        {
            return size() > cachesize;
        }
    }

    public MyCache(int cachesize)
    {
        if (cachesize<1)
            throw new IllegalArgumentException("Cachesize must be greater than zero");
        this.cachesize=cachesize;
        list=new InternalCache<>();
   }

    public synchronized void put(String key, T obj)
    {
        list.put(key,obj);
    }

    public synchronized T get(String key)
    {
        return list.get(key);
    }

    public synchronized void setCacheSize(int cachesize)
    {
        this.cachesize=cachesize;
        if (cachesize<1)
            throw new IllegalArgumentException("Cachesize must be greater than zero");
        // Auf neue Cache-Größe begrenzen erste elemente löschen
        while (list.size()>cachesize)
            list.remove(list.entrySet().iterator().next().getKey());
    }

    public synchronized void clearCache()
    {
        list=new InternalCache<>();
    }

    public synchronized boolean containsKey(String key)
    {
        return list.containsKey(key);
    }

}
