/**
 * Copyright (C) 2018 Achim Kaiser
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.kaisersite.mylibrary;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;

import java.util.ArrayList;


public class CurrentDevice
{
    public static String getName(Context context)
    {
        SharedPreferences sp = context.getSharedPreferences("currentdevice", Context.MODE_PRIVATE);
        return sp.getString("name", null);
    }

    public static String getId(Context context)
    {
        SharedPreferences sp = context.getSharedPreferences("currentdevice", Context.MODE_PRIVATE);
        return sp.getString("id", null);
    }

    public static void setDevice(Context context, String deviceid, String devicename)
    {
        SharedPreferences sp = context.getSharedPreferences("currentdevice", Context.MODE_PRIVATE);
        SharedPreferences.Editor ed = sp.edit();
        if (deviceid==null)
            {
            ed.remove("id");
            ed.remove("name");
            }
        else
            {
            ed.putString("id", deviceid);
            ed.putString("name", devicename);
            }
        ed.commit();
    }

}
