package de.kaisersite.akwearplayer;

import android.content.Intent;
import androidx.core.content.ContextCompat;
import android.util.Log;
import android.widget.Toast;

import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.WearableListenerService;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

import de.kaisersite.mylibrary.DownloadJobService;
import de.kaisersite.mylibrary.MyMediaService;
import de.kaisersite.mylibrary.PlaylistDB;


/*
 *  This is a listener on the  device to get messages via
 *  the datalayer and then pass it to the main activity so it can be
 *  displayed.  the messages should be coming from the wear/watch device.
 */

public class MobileReceiveService extends WearableListenerService
{
    private static final String TAG = "MobileReceiveService";

    @Override
    public void onMessageReceived(MessageEvent messageEvent)
    {

        if (messageEvent.getPath().equals("/download"))
            {
            Log.d(TAG, "Message path received on phone is: " + messageEvent.getPath());

            try
                {
                String message = new String(messageEvent.getData(), StandardCharsets.UTF_8);
                Log.d(TAG, "Message received on phone is: " + message);
                JSONObject json = new JSONObject(message);
                DownloadJobService.startDownload(this, json.getString("title"), json.getString("description"), json.getString("url"),json.getString("description2"),json.getLong("duration"));
                }
            catch (JSONException e)
                {
                e.printStackTrace();
                }
            }
        else if (messageEvent.getPath().equals("/startplaying"))
            {
            Log.d(TAG, "Message path received on phone is: " + messageEvent.getPath());
            String pid=PlaylistDB.getCurrentPlaylistId(this);
            PlaylistDB pldb=new PlaylistDB(this,pid);
            if (pldb.size()>0)
                {
                //Toast.makeText(this, "play", Toast.LENGTH_SHORT).show();
                Intent intent = new Intent(this, MyMediaService.class);
                intent.putExtra("id", pldb.get(0).getId());
                intent.putExtra("playlistid", pid);
                ContextCompat.startForegroundService(this, intent);
                }
            }
        else if (messageEvent.getPath().equals("/stopplaying"))
            {
            Log.d(TAG, "Message path received on phone is: " + messageEvent.getPath());
            Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
            sendBroadcast(intent);
            }
        else
            {
            super.onMessageReceived(messageEvent);
            }
    }

}