package de.kaisersite.akwearplayer;

import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import androidx.annotation.NonNull;
import com.google.android.material.navigation.NavigationView;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.ItemTouchHelper;
import android.text.InputFilter;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.Wearable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.ExecutionException;

import de.kaisersite.mylibrary.CustomListItem;
import de.kaisersite.mylibrary.DownloadJobService;
import de.kaisersite.mylibrary.MyMediaService;
import de.kaisersite.mylibrary.MyPlayListAdapter;
import de.kaisersite.mylibrary.PlayListModel;
import de.kaisersite.mylibrary.PlaylistDB;
import de.kaisersite.mylibrary.Tools;

public class MainActivity extends AppCompatActivity implements MyPlayListAdapter.Controller, NavigationView.OnNavigationItemSelectedListener
{
    private static final String TAG = "MainActivity";

    PlaylistDB playlist;

    private MyPlayListAdapter mItemListAdapter;
    private DrawerLayout mDrawerLayout;
    private RecyclerView mRecyclerView;
    private String playlistid;
    private String playingid;
    private boolean paused=true;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        if (getIntent().getBooleanExtra("cancel", false))
            {
            JobScheduler js = (JobScheduler) getSystemService(Context.JOB_SCHEDULER_SERVICE);
            js.cancelAll();
            }

        setContentView(R.layout.activity_main);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setHomeAsUpIndicator(R.drawable.ic_menu);
        mDrawerLayout = findViewById(R.id.drawer_layout);

        NavigationView navigationView = findViewById(R.id.nav_view);
        navigationView.setNavigationItemSelectedListener(this);

        mRecyclerView = findViewById(R.id.recycler_launcher_view);
        mRecyclerView.setLayoutManager(
                new LinearLayoutManager(this));
        ((SimpleItemAnimator) mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);

        createAdapter();
        setMenugroup();
    }

    private void createAdapter()
    {
        DnDCallback callback = new DnDCallback();
        ItemTouchHelper touchHelper = new ItemTouchHelper(callback);
        touchHelper.attachToRecyclerView(mRecyclerView);

        playlist = new PlaylistDB(this, PlaylistDB.getCurrentPlaylistId(this));
        mItemListAdapter = new MyPlayListAdapter(this, this,touchHelper,playlist,true);
        mItemListAdapter.setHasStableIds(true);
        mRecyclerView.setAdapter(mItemListAdapter);
    }

    private void setMenugroup()
    {
        getSupportActionBar().setSubtitle(PlaylistDB.getName(this,PlaylistDB.getCurrentPlaylistId(this)));
        NavigationView navigationView = findViewById(R.id.nav_view);
        Menu menu=navigationView.getMenu();
        menu.removeGroup(R.id.menugroup);
        String[] arrayids=PlaylistDB.getArray(this);
        MenuItem selectedmenu=null;
        for (int i=0;i<arrayids.length;i++)
            {
            String name=PlaylistDB.getName(this,arrayids[i]);
            MenuItem mi=menu.add(R.id.menugroup, Integer.parseInt(arrayids[i]),1, name);
            if (arrayids[i].equals(playlistid))
                mi.setIcon(R.drawable.ic_play);
            if (arrayids[i].equals(PlaylistDB.getCurrentPlaylistId(this)))
                selectedmenu=mi;
            }
        menu.setGroupCheckable(R.id.menugroup, true,true);
        menu.add(R.id.menugroup, R.id.add_playlist,1, "Add Playlist").setIcon(R.drawable.ic_add_circle);
        selectedmenu.setChecked(true);
    }

    @Override
    public void onBackPressed()
    {
        if (mDrawerLayout.isDrawerOpen(GravityCompat.START))
            {
            mDrawerLayout.closeDrawers();
            return;
            }
        if (mItemListAdapter.getEditmode() == MyPlayListAdapter.EDIT_PLAY)
            {
            super.onBackPressed();
            return;
            }
        mItemListAdapter.setEditmode(MyPlayListAdapter.EDIT_PLAY);
    }


    public void itemSelected(CustomListItem data)
    {
        PlayListModel plItem = (PlayListModel) data;
        if (mItemListAdapter.getEditmode() == MyPlayListAdapter.EDIT_DELETE)
            {
            new File(plItem.getFile()).delete();
            int pos=playlist.getPositon(plItem.getId());
            playlist.deleteItem(plItem.getId());
            mItemListAdapter.notifyItemRemoved(pos);
            Log.d(TAG, "itemDeleted " + data.getTitle());
            }
        else if (mItemListAdapter.getEditmode() == MyPlayListAdapter.EDIT_MOVE)
            {
            int pos=playlist.getPositon(plItem.getId());
            playlist.moveToLast(plItem.getId());
            mItemListAdapter.notifyItemMoved(pos,playlist.size()-1);
            Log.d(TAG, "itemMoved" + data.getTitle());
            }
        else
            {
            if (plItem.getState() == PlayListModel.STATE_LOADING)
                {
                Toast.makeText(this,R.string.still_loading,Toast.LENGTH_SHORT).show();
                return;
                }
            else if (plItem.getState() == PlayListModel.STATE_ERROR)
                {
                Intent intent = new Intent()
                        .putExtra("url", plItem.getUrl())
                        .putExtra("title", plItem.getTitle())
                        .putExtra("desc", plItem.getDescription())
                        .putExtra("file", plItem.getFile())
                        .putExtra("id", plItem.getId())
                        .putExtra("playlistid", PlaylistDB.getCurrentPlaylistId(this));
                playlist.setState(plItem.getId(), PlayListModel.STATE_LOADING);
                DownloadJobService.enqueueWork(this, intent);
                mItemListAdapter.notifyItemChanged(playlist.getPositon(plItem.getId()));
                Toast.makeText(this,R.string.loading,Toast.LENGTH_SHORT).show();
                return;
                }
            else
                {
                startPlaying(plItem.getId());
                }
            }
    }

    public void startPlaying(String id)
    {
        mItemListAdapter.setPlayingId(id, MyPlayListAdapter.CAST_PREPARE);
        Intent intent = new Intent(this, MyMediaService.class);
        intent.putExtra("id", id);
        intent.putExtra("playlistid", PlaylistDB.getCurrentPlaylistId(this));
        ContextCompat.startForegroundService(this, intent);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu)
    {
        MenuInflater inflater = getMenuInflater();
        switch (mItemListAdapter.getEditmode())
            {
            case MyPlayListAdapter.EDIT_MOVE:
            case MyPlayListAdapter.EDIT_DELETE:
                inflater.inflate(R.menu.action_edit, menu);
                break;
            default:
                inflater.inflate(R.menu.action_menu, menu);
            }

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item)
    {
        switch (item.getItemId())
            {
            case android.R.id.home:
            {
            mDrawerLayout.openDrawer(GravityCompat.START);
            return true;
            }
            case R.id.action_add:
            {
            if (android.os.Build.VERSION.SDK_INT <= Build.VERSION_CODES.M && !Settings.System.canWrite(this))
                {
                Intent goToSettings = new Intent(Settings.ACTION_MANAGE_WRITE_SETTINGS);
                goToSettings.setData(Uri.parse("package:" + getPackageName()));
                startActivity(goToSettings);
                return true;
                }
            Intent intent = new Intent(this, UPNPActivity.class);
            startActivity(intent);
            return true;
            }
            case R.id.action_cast:
            {
            if (android.os.Build.VERSION.SDK_INT <= Build.VERSION_CODES.M && !Settings.System.canWrite(this))
                {
                Intent goToSettings = new Intent(Settings.ACTION_MANAGE_WRITE_SETTINGS);
                goToSettings.setData(Uri.parse("package:" + getPackageName()));
                startActivity(goToSettings);
                return true;
                }
            Intent intent = new Intent(this, UPNPActivity.class);
            intent.putExtra("BrowseAVTransport", true);
            startActivity(intent);
            return true;
            }
            case R.id.action_delete:
            {
            closePlayer();
            stopDownload();
            mItemListAdapter.setEditmode(MyPlayListAdapter.EDIT_DELETE);
            invalidateOptionsMenu();
            return true;
            }
            case R.id.action_send:
            {
            sendItems();
            return true;
            }
//            case R.id.action_debug_process:
//            {
//            Tools.debugProcess();
//            return true;
//            }
            case R.id.action_rename_playlist:
            {
            final EditText editText=new EditText(this);
            editText.setText(PlaylistDB.getName(this,PlaylistDB.getCurrentPlaylistId(this)), TextView.BufferType.EDITABLE);
            editText.selectAll();
            editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(30)});
            AlertDialog dialog = new AlertDialog.Builder(this)
                    .setTitle(R.string.dialog_rename)
                    .setView(editText)
                    .setPositiveButton(R.string.ok, new DialogInterface.OnClickListener()
                    {
                        @Override
                        public void onClick(DialogInterface dialog, int which)
                        {
                            PlaylistDB.setPlaylistName(
                                    MainActivity.this,
                                    PlaylistDB.getCurrentPlaylistId(MainActivity.this),
                                    String.valueOf(editText.getText()));
                            setMenugroup();
                        }
                    })
                    .setNegativeButton(R.string.cancel,null)
                    .create();
            dialog.show();
            // show keyboard
            editText.post(new Runnable()
            {
                @Override
                public void run()
                {
                    editText.requestFocus();
                    InputMethodManager imm = (InputMethodManager)   getSystemService(Context.INPUT_METHOD_SERVICE);
                    imm.showSoftInput(editText, InputMethodManager.SHOW_IMPLICIT);
                }
            });
            return true;
            }
            case R.id.action_leave:
            {
            mItemListAdapter.setEditmode(MyPlayListAdapter.EDIT_PLAY);
            invalidateOptionsMenu();
            return true;
            }
            case R.id.action_delete_playlist:
            {
            if (PlaylistDB.getCurrentPlaylistId(this).equals(playlistid))
                closePlayer();
            stopDownload();
            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setMessage("Are you sure?").setPositiveButton("Yes", dialogClickListener)
                    .setNegativeButton("No", dialogClickListener).show();
            return true;
            }
            case R.id.action_legal:
            {
            Intent intent = new Intent(Intent.ACTION_VIEW)
                    .addCategory(Intent.CATEGORY_BROWSABLE)
                    .setData(Uri.parse("https://www.kaisersite.de/akwearplayer"));
            Toast.makeText(this, R.string.toast_legal_link, Toast.LENGTH_SHORT).show();
            startActivity(intent);
            return true;
            }
            case R.id.action_version:
            {
            Intent intent = new Intent(this, VersionActivity.class);
            startActivity(intent);
            return true;
            }
            default:
                // If we got here, the user's action was not recognized.
                // Invoke the superclass to handle it.
                return super.onOptionsItemSelected(item);

            }
    }


    private void sendItems()
    {
        // Trigger an AsyncTask that will query for a list of connected nodes and send a
        // "start-activity" message to each connected node.
        new StartWearableActivityTask().execute();

    }

    private void closePlayer()
    {
        Intent intent = new Intent(MyMediaService.CLOSE_PLAYER);
        sendBroadcast(intent);
    }

    private void stopDownload()
    {
        JobScheduler js = (JobScheduler) getSystemService(Context.JOB_SCHEDULER_SERVICE);
        js.cancelAll();
        PlaylistDB.setAllLoadingToError(this);
        mItemListAdapter.notifyDataSetChanged();
    }

    @Override
    public boolean onNavigationItemSelected(@NonNull MenuItem item)
    {
        // set item as selected to persist highlight
        String pid=""+item.getItemId();
        if (PlaylistDB.contains(this, pid))
            {
            item.setChecked(true);
            invalidateOptionsMenu();
            PlaylistDB.setCurrentPlaylistId(this,pid);
            getSupportActionBar().setSubtitle(PlaylistDB.getName(this,pid));
            createAdapter();
            Intent bcintent = new Intent(MyMediaService.REQUEST_PLAYSTATUS);
            //send broadcast
            LocalBroadcastManager.getInstance(this).sendBroadcast(bcintent);

            }
        else
            {
            switch (item.getItemId())
                {
                case R.id.add_playlist:
                    PlaylistDB.setCurrentPlaylistId(this,PlaylistDB.addPlaylist(this));
                    createAdapter();
                    setMenugroup();
                    break;
                case R.id.action_legal:
                    onOptionsItemSelected(item);
                    break;
                case R.id.action_version:
                    onOptionsItemSelected(item);
                    break;
                }
            }
        // close drawer when item is tapped
        mDrawerLayout.closeDrawers();

        // Add code here to update the UI based on the item selected
        // For example, swap UI fragments here

        return true;
    }

    private class StartWearableActivityTask extends AsyncTask<Void, Void, Void>
    {
        @Override
        protected Void doInBackground(Void... args)
        {
            //first get all the nodes, ie connected wearable devices.
            Task<List<Node>> nodeListTask =
                    Wearable.getNodeClient(getApplicationContext()).getConnectedNodes();
            try
                {
                // Block on a task and get the result synchronously (because this is on a background
                // thread).
                List<Node> nodes = Tasks.await(nodeListTask);
                //Now send the message to each device.
                for (Node node : nodes)
                    {
                    for (int i=0;i<playlist.size();i++)
                        {
                        byte[] data;
                        try
                            {
                            JSONObject json = new JSONObject();
                            String id=playlist.get(i).getId();
                            json.put("title",playlist.getItem(id).getTitle());
                            json.put("description",playlist.getItem(id).getDescription());
                            json.put("url",playlist.getItem(id).getUrl());
                            json.put("description2",playlist.getItem(id).getDescription2());
                            json.put("duration",playlist.getItem(id).getDuration());
                            json.put("url",playlist.getItem(id).getUrl());
                            data=json.toString().getBytes("UTF-8");
                            }
                        catch (JSONException e)
                            {
                            continue;
                            }
                        catch (UnsupportedEncodingException e)
                            {
                            continue;
                            }
                        Task<Integer> sendMessageTask =
                                Wearable.getMessageClient(MainActivity.this).sendMessage(node.getId(), "/download",data);

                        try
                            {
                            // Block on a task and get the result synchronously (because this is on a background
                            // thread).
                            Integer result = Tasks.await(sendMessageTask);
                            Log.v(TAG, "SendThread: message send to " + node.getDisplayName());

                            }
                        catch (ExecutionException exception)
                            {
                            Log.e(TAG, "Task failed: " + exception);

                            }
                        catch (InterruptedException exception)
                            {
                            Log.e(TAG, "Interrupt occurred: " + exception);
                            }

                        }

                    }

                }
            catch (ExecutionException exception)
                {
                Log.e(TAG, "Task failed: " + exception);

                }
            catch (InterruptedException exception)
                {
                Log.e(TAG, "Interrupt occurred: " + exception);
                }
            return null;
        }
    }

    DialogInterface.OnClickListener dialogClickListener = new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
            switch (which){
            case DialogInterface.BUTTON_POSITIVE:
                int itemsize=playlist.size();
                for (int i = 0; i<itemsize; i++)
                    {
                    PlayListModel plm=playlist.get(0);
                    new File(plm.getFile()).delete();
                    playlist.deleteItem(plm.getId());
                    }
                String newpid=PlaylistDB.deletePlaylist(MainActivity.this,PlaylistDB.getCurrentPlaylistId(MainActivity.this));
                PlaylistDB.setCurrentPlaylistId(MainActivity.this,newpid);
                setMenugroup();
                createAdapter();
                break;

            case DialogInterface.BUTTON_NEGATIVE:
                //No button clicked
                break;
            }
        }
    };

    //broadcast intent for update list
    private BroadcastReceiver mMessageReceiverUpdateDownload = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            mItemListAdapter.notifyDataSetChanged();
        }
    };

    //broadcast intent for playing from MyMediaService
    private BroadcastReceiver mMessageReceiverUpdatePlaying = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            playlistid = intent.getStringExtra("id")==null ? null : intent.getStringExtra("playlistid");

            if (PlaylistDB.getCurrentPlaylistId(context).equals(intent.getStringExtra("playlistid")))
                {
                playingid=intent.getStringExtra("id");
                mItemListAdapter.setPlayingId(intent.getStringExtra("id"), intent.getBooleanExtra("paused", true)?MyPlayListAdapter.CAST_PAUSE:MyPlayListAdapter.CAST_PLAY);
                paused=intent.getBooleanExtra("paused", true);
                }
            else
                {
                playingid=null;
                mItemListAdapter.setPlayingId(null, MyPlayListAdapter.CAST_NONE);
                }
            setMenugroup();
        }
    };


    @Override
    public void onResume()
    {
        super.onResume();
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiverUpdateDownload, new IntentFilter(DownloadJobService.UPDATE_DOWNLOAD));
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiverUpdatePlaying, new IntentFilter(MyMediaService.UPDATE_PLAYING));

        mItemListAdapter.setPlayingId(null, MyPlayListAdapter.CAST_NONE);
        mItemListAdapter.notifyDataSetChanged();

        Intent bcintent = new Intent(MyMediaService.REQUEST_PLAYSTATUS);
        //send broadcast
        LocalBroadcastManager.getInstance(this).sendBroadcast(bcintent);
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiverUpdateDownload);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiverUpdatePlaying);
    }

    @Override
    protected void onNewIntent(Intent intent)
    {
        super.onNewIntent(intent);
        if (intent.getBooleanExtra("cancel", false))
            {
            JobScheduler js = (JobScheduler) getSystemService(Context.JOB_SCHEDULER_SERVICE);
            js.cancelAll();
            }
    }

    private class DnDCallback extends  ItemTouchHelper.Callback
    {

        @Override
        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder)
        {
            int dragFlags = ItemTouchHelper.UP | ItemTouchHelper.DOWN;
            int swipeFlags = ItemTouchHelper.START | ItemTouchHelper.END;
            return makeMovementFlags(dragFlags, swipeFlags);
        }

        @Override
        public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target)
        {
            playlist.move(viewHolder.getAdapterPosition(),target.getAdapterPosition());
            mItemListAdapter.notifyItemMoved(viewHolder.getAdapterPosition(),target.getAdapterPosition());
            updatePlayNext();
            return true;
        }

        @Override
        public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction)
        {
            final PlayListModel plItem=playlist.get(viewHolder.getAdapterPosition());
            if (plItem.getId().equals(playingid) && PlaylistDB.getCurrentPlaylistId(MainActivity.this).equals(playlistid))
                {
                String next= playlist.getNextId(playingid);
                if (next==null || MainActivity.this.paused)
                    closePlayer();
                else
                    startPlaying(next);
                }
            if (plItem.getState()==PlayListModel.STATE_LOADING)
                stopDownload();
            playlist.deleteItem(plItem.getId());
            final int pos=viewHolder.getAdapterPosition();
            mItemListAdapter.notifyItemRemoved(pos);
            updatePlayNext();
            if (plItem.getState()!=PlayListModel.STATE_LOADED)
                {
                Log.d(TAG, "Delete " + plItem.getTitle());
                new File(plItem.getFile()).delete();
                }
            else
                {
                Snackbar snackbar = Snackbar
                        .make(mRecyclerView, "Deleted", Snackbar.LENGTH_LONG)
                        .setAction("UNDO",new View.OnClickListener() {
                            @Override
                            public void onClick(View v)
                            {
                                Log.d(TAG, "Undo " + plItem.getTitle());
                                playlist.addItem(plItem.getUrl(), plItem.getId(), plItem.getFile(), plItem.getTitle(), plItem.getDescription(), plItem.getDescription2(), plItem.getDuration());
                                playlist.setState(plItem.getId(),PlayListModel.STATE_LOADED);
                                playlist.move(playlist.size()-1,pos);
                                mItemListAdapter.notifyItemInserted(pos);
                                updatePlayNext();
                            }
                        })
                        .addCallback(new Snackbar.Callback()
                        {
                            @Override
                            public void onDismissed(Snackbar transientBottomBar, int event)
                            {
                                super.onDismissed(transientBottomBar, event);
                                if (event != Snackbar.Callback.DISMISS_EVENT_ACTION)
                                    {
                                    Log.d(TAG, "Delete " + plItem.getTitle());
                                    new File(plItem.getFile()).delete();
                                    }
                            }
                        });
                snackbar.show();
                }
        }

        @Override
        public boolean isLongPressDragEnabled() {
            return false;
        }
        @Override
        public boolean isItemViewSwipeEnabled() {
            return true;
        }
    }

    private void updatePlayNext()
    {
        Intent bcintent = new Intent(MyMediaService.UPDATE_NEXT);
        LocalBroadcastManager.getInstance(this).sendBroadcast(bcintent);
    }

}
