package de.kaisersite.akwearplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.appcompat.app.AlertDialog;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import de.kaisersite.mylibrary.CurrentDevice;
import de.kaisersite.mylibrary.MyMediaPlayerUPNP;
import de.kaisersite.mylibrary.MyMediaService;


/**
 *
 */
public class InfoUPNPFragment extends Fragment implements View.OnClickListener
{
    private static final String TAG = "InfoSeekUPNPFragment";
    private ProgressBar progressBar;
    private TextView titleView;

    public InfoUPNPFragment()
    {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState)
    {
        Log.d(TAG,"onCreateView");
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_infoupnp, container, false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState)
    {
        super.onActivityCreated(savedInstanceState);
        ImageView cancelbutton=getView().findViewById(R.id.cancelButton);
        cancelbutton.setOnClickListener(this);
        titleView=getView().findViewById(R.id.titleView);
        progressBar=getView().findViewById(R.id.progress);
        if (CurrentDevice.getId(getContext())!=null)
            getView().setVisibility(View.VISIBLE);
        else
            getView().setVisibility(View.GONE);
    }

    @Override
    public void onAttach(Context context)
    {
        super.onAttach(context);
    }

    @Override
    public void onDetach()
    {
        super.onDetach();
    }

    @Override
    public void onResume()
    {
        super.onResume();
        LocalBroadcastManager.getInstance(getContext()).registerReceiver(mMessageReceiverCastInfo, new IntentFilter(MyMediaPlayerUPNP.UPNP_INFO));
        if (CurrentDevice.getId(getContext())==null)
            getView().setVisibility(View.GONE);
        else
            {
            String text = "";
            if (CurrentDevice.getName(getContext()) != null)
                text += CurrentDevice.getName(getContext());
            titleView.setText(text);
            progressBar.setVisibility(View.GONE);
            getView().setVisibility(View.VISIBLE);
            }
    }

    @Override
    public void onPause()
    {
        super.onPause();
        LocalBroadcastManager.getInstance(getContext()).unregisterReceiver(mMessageReceiverCastInfo);
    }



    private BroadcastReceiver mMessageReceiverCastInfo = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            Log.d(TAG,"receive");
            if (CurrentDevice.getId(getContext())==null)
                {
                getView().setVisibility(View.GONE);
                }
            else
                {
                String text="";
                if (CurrentDevice.getName(getContext())!=null)
                    text+=CurrentDevice.getName(getContext());
                if (intent.getStringExtra("statustext")!=null)
                    text+=" "+intent.getStringExtra("statustext");
                titleView.setText(text);
                progressBar.setVisibility(intent.getBooleanExtra("progress",false)?View.VISIBLE:View.GONE);
                getView().setVisibility(View.VISIBLE);
                }
        }
    };

    @Override
    public void onClick(View v)
    {
        AlertDialog dialog = new AlertDialog.Builder(getContext())
                .setTitle(R.string.dialog_stop_playing)
                .setPositiveButton(R.string.yes, new DialogInterface.OnClickListener()
                {
                    @Override
                    public void onClick(DialogInterface dialog, int which)
                    {
                        CurrentDevice.setDevice( getContext(),null,null);
                        Intent intent = new Intent(MyMediaService.CLOSE_PLAYER_STOP_CLOSE);
                        intent.putExtra("stop",true);
                        getContext().sendBroadcast(intent);
                        InfoUPNPFragment.this.getView().setVisibility(View.GONE);
                    }
                })
                .setNegativeButton(R.string.no,new DialogInterface.OnClickListener()
                {
                    @Override
                    public void onClick(DialogInterface dialog, int which)
                    {
                        CurrentDevice.setDevice( getContext(),null,null);
                        Intent intent = new Intent(MyMediaService.CLOSE_PLAYER_CLOSE);
                        getContext().sendBroadcast(intent);
                        InfoUPNPFragment.this.getView().setVisibility(View.GONE);
                    }
                })
                .setNeutralButton(R.string.cancel,null)
                .create();
        dialog.show();

    }
}
