package de.kaisersite.akwearplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.fragment.app.Fragment;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;

import de.kaisersite.mylibrary.MyMediaService;
import de.kaisersite.mylibrary.PlayListModel;
import de.kaisersite.mylibrary.PlaylistDB;
import de.kaisersite.mylibrary.Tools;


/**
 *
 */
public class InfoSeekFragment extends Fragment implements SeekBar.OnSeekBarChangeListener, View.OnClickListener
{
    private static final String TAG = "InfoSeekFragment";
    private ImageView albumicon;
    private int widthImage;
    private TextView titleView;
    private TextView descriptionView;
    private TextView hhmmView;
    private SeekBar seekBar;
    private Handler handler;
    private MyTask myTask;
    private long lasttimeposition;
    private int iDuration;
    private String playingid=null;
    private String playlistid=null;

    public InfoSeekFragment()
    {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        handler=new Handler(Looper.getMainLooper());
        myTask=new MyTask();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState)
    {
        Log.d(TAG,"onCreateView");
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_infoseek, container, false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState)
    {
        super.onActivityCreated(savedInstanceState);
        albumicon=getView().findViewById(R.id.icon);
        widthImage =(int)getResources().getDimension(de.kaisersite.mylibrary.R.dimen.albumimagewidgetwidth);
        titleView=getView().findViewById(R.id.titleView);
        descriptionView=getView().findViewById(R.id.descriptionView);
        seekBar=getView().findViewById(R.id.seekBar);
        hhmmView=getView().findViewById(R.id.hhmmView);
        seekBar.setMax(0);
        seekBar.setOnSeekBarChangeListener(this);
        albumicon.setOnClickListener(this);
    }

    @Override
    public void onAttach(Context context)
    {
        super.onAttach(context);
    }

    @Override
    public void onDetach()
    {
        super.onDetach();
    }

    @Override
    public void onResume()
    {
        super.onResume();
        LocalBroadcastManager.getInstance(getContext()).registerReceiver(mMessageReceiverUpdatePlaying, new IntentFilter(MyMediaService.UPDATE_PLAYING));
    }

    @Override
    public void onPause()
    {
        super.onPause();
        LocalBroadcastManager.getInstance(getContext()).unregisterReceiver(mMessageReceiverUpdatePlaying);
        handler.removeCallbacks(myTask);
    }



    //broadcast intent for playing from MyMediaService
    private BroadcastReceiver mMessageReceiverUpdatePlaying = new BroadcastReceiver()
    {
        @Override
        public void onReceive(Context context, Intent intent)
        {
            Log.d(TAG,"receive");
            updateView(intent.getStringExtra("playlistid"),
                    intent.getStringExtra("id"),
                    intent.getBooleanExtra("paused",true),intent.getIntExtra("currentpos",0),intent.getIntExtra("duration",0));

        }
    };

    public void updateView(String pid, String id, boolean paused, int currentpos, int duration)
    {
        playingid=id;
        playlistid=pid;
        long currenttime=System.currentTimeMillis();
        if (id == null)
            {
            albumicon.setImageResource(android.R.color.transparent);
            titleView.setText("-");
            descriptionView.setText("-");
            setHHMMText(0,0);
            handler.removeCallbacks(myTask);
            seekBar.setProgress(0);
            seekBar.setMax(0);
            return;
            }
        PlayListModel plm = new PlaylistDB(getContext(), pid).getItem(id);
        seekBar.setMax(duration);
        seekBar.setProgress(currentpos);
        titleView.setText(plm.getTitle());
        descriptionView.setText(plm.getDescription());
        setHHMMText(currentpos/1000,duration/1000);
        lasttimeposition=currenttime-currentpos;
        iDuration=duration;
        if (!paused)
            {
            handler.removeCallbacks(myTask);
            handler.postDelayed(myTask,1000-(currenttime-lasttimeposition)%1000);
            }
        else
            {
            handler.removeCallbacks(myTask);
            }
        Bitmap bitmap= Tools.getMediaBitmap(plm.getFile());
        if (bitmap!=null)
            {
            bitmap = Bitmap.createScaledBitmap(bitmap, widthImage, bitmap.getHeight() * widthImage / bitmap.getWidth(), true);
            albumicon.setImageBitmap(bitmap);
            }
        else
            {
            albumicon.setImageResource(R.drawable.ic_file);
            }
   }

    @Override
    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
    {
        if (fromUser)
            setHHMMText(progress/1000,iDuration/1000);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar)
    {
        handler.removeCallbacks(myTask);
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar)
    {
        Intent bcintent = new Intent(MyMediaService.SEEKTO);

        //put whatever data you want to send, if any
        bcintent.putExtra("seekto", seekBar.getProgress());

        //send broadcast
        LocalBroadcastManager.getInstance(getContext()).sendBroadcast(bcintent);

    }

    @Override
    public void onClick(View v)
    {
        if (playingid==null || playlistid==null)
            return;
        Intent intent = new Intent(getContext(), MyMediaService.class);
        intent.putExtra("id", playingid);
        intent.putExtra("playlistid", playlistid);
        ContextCompat.startForegroundService(getContext(), intent);

    }


    public class MyTask implements Runnable
    {
        @Override
        public void run() {
            Log.d(TAG,"myTask");
            long currenttime=System.currentTimeMillis();
            if (currenttime-lasttimeposition>iDuration)
                lasttimeposition=currenttime-iDuration;
            seekBar.setProgress((int)(currenttime-lasttimeposition));
            setHHMMText((int)(currenttime-lasttimeposition)/1000,iDuration/1000);
            handler.postDelayed(myTask,1000-(currenttime-lasttimeposition)%1000);
        }
    }

    public void setHHMMText(int positionsec,int durationsec)
    {
        hhmmView.setText(getString(R.string.seekbarHHMM,positionsec/60,positionsec%60,durationsec/60,durationsec%60));
    }
}
